/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassListCellRenderer;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassProxy;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWAdvancedFieldNameCellEditor;
import filenet.vw.toolkit.design.property.tables.VWCreateWorkflowInstructionAssignmentTableModel;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditor;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWCreateWorkflowParamPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
ActionListener,
IVWCoordinationEventListener {
    protected JComboBox m_workflowNameComboBox = null;
    protected VWToolbarBorder m_fieldsBorder = null;
    protected VWCreateWorkflowInstructionAssignmentTableModel m_fieldsTableModel = null;
    protected VWTable m_fieldsTable = null;
    protected VWAdvancedFieldNameCellEditor m_fieldNameCellEditor = null;
    protected VWExpressionCellEditor m_expressionCellEditor = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;
    private boolean m_firstTime = true;
    private int m_nOrientation = 0;

    public VWCreateWorkflowParamPanel(int nOrientation) {
        switch (nOrientation) {
            case 0: 
            case 1: {
                this.m_nOrientation = nOrientation;
            }
        }
    }

    public void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.setLayout(new BorderLayout(5, 5));
        switch (this.m_nOrientation) {
            case 1: {
                this.add((Component)this.getWorkflowNameControlPanel(), "First");
                break;
            }
            default: {
                this.add((Component)this.getWorkflowNameControlPanel(), "Before");
            }
        }
        this.add((Component)this.getDataFieldsControlPanel(), "Center");
        this.initWorkflowNameComboBox();
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        if (this.m_fieldsTable != null) {
            this.m_fieldsTable.stopEditing();
        }
        this.m_instructionDef = instructionDef;
        if (this.m_instructionDef == null) return;
        this.m_fieldsTableModel.setInstructionDefinition(this.m_instructionDef);
        this.initWorkflowNameComboBox();
        String workflowName = VWInstruction.CreateInstructionGetWorkClass(this.m_instructionDef);
        if (workflowName != null && workflowName.compareTo("") != 0) {
            try {
                this.m_workflowNameComboBox.removeActionListener(this);
                VWWorkClassProxy proxyItem = null;
                boolean bFound = false;
                ComboBoxModel comboBoxModel = this.m_workflowNameComboBox.getModel();
                for (int i = 1; i < comboBoxModel.getSize(); ++i) {
                    proxyItem = (VWWorkClassProxy)comboBoxModel.getElementAt(i);
                    if (VWStringUtils.compare(workflowName, proxyItem.getName()) != 0) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    proxyItem = new VWWorkClassProxy(workflowName, 0, this.m_authPropertyData);
                    this.m_workflowNameComboBox.insertItemAt(proxyItem, 1);
                }
                this.m_workflowNameComboBox.setSelectedItem(proxyItem);
                if (!bFound) return;
                this.updateWorkflowName();
                return;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                return;
            }
            finally {
                this.m_workflowNameComboBox.addActionListener(this);
            }
        } else {
            if (this.m_workflowNameComboBox.getItemCount() <= 0) return;
            this.m_workflowNameComboBox.setSelectedIndex(0);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_firstTime) {
            this.m_firstTime = false;
            if (this.m_fieldsTable != null) {
                this.m_fieldsTable.fitColumnsInTable();
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            Object src = event.getSource();
            if (src == this.m_fieldsBorder) {
                switch (event.getID()) {
                    case 0x10000000: {
                        this.m_fieldsTableModel.deleteItem(this.m_fieldsTable.getSelectedRow());
                        break;
                    }
                    case 1: {
                        this.onUp();
                        break;
                    }
                    case 2: {
                        this.onDown();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_fieldsTable.getSelectedRow()) {
                    this.m_fieldsTable.clearSelection();
                }
                this.m_fieldsTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowCount;
            this.m_fieldsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_fieldsBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_fieldsTable.getSelectedRow();
            if (this.m_fieldsTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_fieldsTableModel.getRowCount()) - 1) {
                this.m_fieldsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_fieldsBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                if (nRowIndex == 0) {
                    this.m_fieldsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_fieldsBorder.getClientPanel(), 2, 1));
                }
                if (nRowIndex == nRowCount - 2) {
                    this.m_fieldsBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_fieldsBorder.getClientPanel(), 2, 2));
                }
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_workflowNameComboBox) {
            this.updateWorkflowName();
            this.m_fieldsTableModel.initRows();
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 705: 
            case 706: 
            case 707: 
            case 710: {
                this.setInstructionDefinition(this.m_instructionDef);
            }
        }
    }

    protected void onUp() {
        try {
            int nRowIndex = this.m_fieldsTable.getSelectedRow();
            if (nRowIndex > 0) {
                this.m_fieldsTableModel.up(nRowIndex);
                this.m_fieldsTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onDown() {
        try {
            int nRowIndex = this.m_fieldsTable.getSelectedRow();
            if (nRowIndex < this.m_fieldsTableModel.getRowCount() - 2) {
                this.m_fieldsTableModel.down(nRowIndex);
                this.m_fieldsTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        if (this.m_workflowNameComboBox != null) {
            this.m_workflowNameComboBox.removeActionListener(this);
            this.m_workflowNameComboBox.removeAll();
            this.m_workflowNameComboBox = null;
        }
        if (this.m_fieldsTable != null) {
            this.m_fieldsTable.getSelectionModel().removeListSelectionListener(this);
            this.m_fieldsTable.removeAll();
            this.m_fieldsTable = null;
        }
        if (this.m_fieldsTableModel != null) {
            this.m_fieldsTableModel.releaseReferences();
            this.m_fieldsTableModel = null;
        }
        if (this.m_fieldsBorder != null) {
            this.m_fieldsBorder.removeToolbarBorderActionNotifier(this);
            this.m_fieldsBorder.releaseReferences();
            this.m_fieldsBorder = null;
        }
        this.m_fieldNameCellEditor = null;
        this.m_expressionCellEditor = null;
        this.m_instructionDef = null;
        this.m_authPropertyData = null;
    }

    private JPanel getWorkflowNameControlPanel() {
        VWToolbarBorder workflowNameBorder = new VWToolbarBorder(VWResource.s_workflowNameStr);
        JPanel workflowNamePanel = workflowNameBorder.getClientPanel();
        workflowNamePanel.setLayout(new BorderLayout());
        this.m_workflowNameComboBox = new JComboBox();
        this.m_workflowNameComboBox.addActionListener(this);
        this.m_workflowNameComboBox.setRenderer(new VWWorkClassListCellRenderer());
        workflowNamePanel.add((Component)this.m_workflowNameComboBox, "First");
        return workflowNameBorder;
    }

    private JPanel getDataFieldsControlPanel() {
        this.m_fieldsBorder = new VWToolbarBorder(VWResource.s_assignmentsStr, 0x10000003);
        this.m_fieldsBorder.addToolbarBorderActionNotifier(this);
        JPanel fieldsPanel = this.m_fieldsBorder.getClientPanel();
        fieldsPanel.setLayout(new BorderLayout());
        this.m_fieldsTableModel = new VWCreateWorkflowInstructionAssignmentTableModel(this.m_authPropertyData, this.m_instructionDef);
        this.m_fieldsTableModel.addTableModelListener(this);
        this.m_fieldsTable = new VWTable(this.m_fieldsTableModel);
        this.m_fieldsTable.setRowSelectionAllowed(true);
        this.m_fieldsTable.getSelectionModel().addListSelectionListener(this);
        this.m_fieldsTable.getSelectionModel().setSelectionMode(0);
        fieldsPanel.add((Component)new JScrollPane(this.m_fieldsTable), "Center");
        TableColumn tcElement = this.m_fieldsTable.getColumnModel().getColumn(0);
        if (tcElement != null) {
            this.m_fieldNameCellEditor = new VWAdvancedFieldNameCellEditor(this.m_authPropertyData, false);
            tcElement.setCellEditor(this.m_fieldNameCellEditor);
        }
        if ((tcElement = this.m_fieldsTable.getColumnModel().getColumn(1)) != null) {
            this.m_expressionCellEditor = new VWExpressionCellEditor((IVWPropertyData)this.m_authPropertyData, 103);
            tcElement.setCellEditor(this.m_expressionCellEditor);
            tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        return this.m_fieldsBorder;
    }

    private void initWorkflowNameComboBox() {
        try {
            if (this.m_authPropertyData != null) {
                VWWorkClassProxy[] workClasses = VWWorkClassProxy.getAvailableWorkClasses(this.m_authPropertyData);
                DefaultComboBoxModel<VWWorkClassProxy> cbModel = new DefaultComboBoxModel<VWWorkClassProxy>(workClasses);
                cbModel.insertElementAt((VWWorkClassProxy)((Object)VWResource.s_none), 0);
                this.m_workflowNameComboBox.removeActionListener(this);
                this.m_workflowNameComboBox.setModel(cbModel);
                this.m_workflowNameComboBox.setSelectedIndex(0);
                this.m_workflowNameComboBox.addActionListener(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateWorkflowName() {
        VWWorkClassProxy workClassProxy = null;
        String workClassName = "";
        Object selectedItem = this.m_workflowNameComboBox.getSelectedItem();
        if (selectedItem != null && selectedItem instanceof VWWorkClassProxy) {
            workClassProxy = (VWWorkClassProxy)selectedItem;
            workClassName = workClassProxy.getName();
        }
        VWInstruction.CreateInstructionSetWorkClass(this.m_instructionDef, workClassName);
        this.m_authPropertyData.setDirty();
        if (this.m_fieldNameCellEditor != null) {
            this.m_fieldNameCellEditor.setWorkClassProxy(workClassProxy);
        }
        if (this.m_expressionCellEditor != null) {
            this.m_expressionCellEditor.setWorkClassProxy(workClassProxy);
        }
    }
}

